import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { IncomeCashExchangeComponent } from './incomeCashExchange.component';
const routes: Routes = [
  {
    path: '',
    component: IncomeCashExchangeComponent,

    children: [
      { path: '', redirectTo: '', pathMatch: 'prefix' },
      {
        path: '',
        data: { title: 'نقد درآمد ارزی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderIncomeCashExchangeModule
          ),
      },
      {
        path: ':language',
        data: { title: 'نقد درآمد ارزی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderIncomeCashExchangeModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class IncomeCashExchangeRoutingModule {}
