import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Output,
  EventEmitter,
} from '@angular/core';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Component({
  selector: 'app-incomeCashExchange-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderIncomeCashExchangeComponent
  implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  activeIndex: number = 0;
  timeout = null;
  @Output() isOrderSelectedChange = new EventEmitter;

  orderOptions = [
    { value: 167, title: 'ارسال حواله به ایران' },
    { value: 907, title: 'فروش وایز' },
    { value: 171, title: 'نقد پی پال' },
    // { value: 906, title: 'نقد پایر (آنی)' },
    { value: 969, title: 'نقد رولوت' },
    { value: 981, title: 'نقد Zen' },

  ];
  constructor(
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _activatedRoute: ActivatedRoute) { }

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/incomeCashExchange/' +
        this._activatedRoute.snapshot.params['language']
      );
    this.cdr.detectChanges();
  }

  ngAfterViewInit() { }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
