import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { scrollTop } from '@helpers/window.helper';
import { StyleStore } from '@stores/style.store';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: "payeer",
  templateUrl: "./payeer.component.html",
  styleUrls: ["./payeer.component.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})

export class PayeerComponent
  implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  url = window.location.href;
  orderType: string;

  constructor(private _styleStore: StyleStore,
    private cdr: ChangeDetectorRef,
    public _activatedroute: ActivatedRoute,

  ) { }

  ngOnInit(): void {
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false
    });
    // this.getOrderType();

  }

  ngAfterViewInit() { }

  onActivate(event) {
    scrollTop();
  }

  getOrderType() {
    this.orderType = this.url.split('/')[5];
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}