import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PayeerComponent } from './payeer.component';

const routes: Routes = [
  {
    path: '',
    component: PayeerComponent,
    data: {
      title: 'پایر',
      breadcrumb: [{ title: 'پایر', url: '/dashboard/Cat/payeer' }],
    },
    children: [
      {
        path: 'accountRecharge',

        loadChildren: () =>
          import('./payeerAccountRecharge/payeerAccountRecharge.module').then(
            (m) => m.PayeerAccountRechargeModule
          ),
      },
      {
        path: 'accountRecharge/:language',

        loadChildren: () =>
          import('./payeerAccountRecharge/payeerAccountRecharge.module').then(
            (m) => m.PayeerAccountRechargeModule
          ),
      },
      {
        path: 'sell',

        loadChildren: () =>
          import('./payeerSelling/payeerSelling.module').then(
            (m) => m.PayeerSellingModule
          ),
      },
      {
        path: 'sell/:language',

        loadChildren: () =>
          import('./payeerSelling/payeerSelling.module').then(
            (m) => m.PayeerSellingModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PayeerRoutingModule {}
