import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PayeerAccountRechargeComponent } from './payeerAccountRecharge.component';
const routes: Routes = [
  {
    path: '',
    component: PayeerAccountRechargeComponent,
    data: {
      breadcrumb: [
        {
          title: 'شارژ حساب پایر',
          url: '/dashboard/services/payeer/accountRecharge',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPayeerAccountRechargeModule
          ),
      },
      {
        path: ':language',
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPayeerAccountRechargeModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PayeerAccountRechargeRoutingModule {}
