import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { PayeerSellingPriceModel } from '@models/orders/PayeerSellingPriceModel';
import { PayeerSellingSaveModel } from 'src/app/core/params/order/PayeerSellingSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DetectHelper } from '@helpers/detectHelper';
import { MenuItem } from 'primeng/api';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'form-PayeerSelling',
  templateUrl: './formPayeerSelling.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class FormPayeerSellingComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  data: UserProfile;
  timeout = null;
  dataPrice: PayeerSellingPriceModel;
  model: PayeerSellingSaveModel = new PayeerSellingSaveModel();
  isLoading: boolean = false;
  totalQuestionRecord: number = 0;
  isValidLegalForm: boolean = true;
  isSideFix: boolean = false;
  isDesktop: boolean;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  displayModal: boolean = false;
  totalRecord: number = 0;
  orderType: number = 906;
  dataUser: UserProfile;
  errMsg: any;
  imageId: string;
  isVerifiedInfo: boolean = false;

  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private detectHelper: DetectHelper,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  ngOnInit(): void {
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
  }

  

  ngAfterViewInit() {
    this.getFullOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (this.dataCurrency != null && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingPayeerGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  onFilter() {
    this.detectHelper.fullCompelete(this.cdr);
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.SellingPayeerSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingpayeer/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
