import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy
} from '@angular/core';
import { scrollTop } from '@helpers/window.helper';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';
@Component({
  selector: 'app-PayeerSelling-transfer',
  templateUrl: './payeerSelling.component.html',
   
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class PayeerSellingComponent implements OnDestroy {
  subscriptions = new Subscription();

  constructor() {}

  onActivate(event) {
    scrollTop();
 }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
