import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PayeerSellingComponent } from './payeerSelling.component';
const routes: Routes = [
  {
    path: '',
    component: PayeerSellingComponent,
    data: {
      breadcrumb: [
        {
          title: 'فروش پایر',
          url: '/dashboard/services/payeer/sell',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPayeerSellingModule
          ),
      },
      {
        path: ':language',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPayeerSellingModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PayeerSellingRoutingModule {}
