import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
  ElementRef,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subject, Subscription, takeUntil } from 'rxjs';
import { response } from '@interfaces/response';
import { PaymentInternationalSitesPriceModel } from '@models/orders/PaymentInternationalSitesPriceModel';
import { PaymentInternationalSitesSaveModel } from 'src/app/core/params/order/PaymentInternationalSitesSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { isUrlValid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from '../../components/legal-order/legal-order.component';
import { IStatic } from '@interfaces/dbo/iStatic';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { DialogService, DynamicDialogRef } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { animate, style, transition, trigger } from '@angular/animations';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { TranslateService } from '@ngx-translate/core';
import { IUserAddress } from '@interfaces/user/iUserAddress';
import { IWeightUnits } from '@interfaces/orders/iWeightUnits';
import { SelectAddressModalComponent } from '../../components/selectAddressModal/selectAddressModal.component';
import { NgForm } from '@angular/forms';
@Component({
  selector: 'app-paymentinternationalsites-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({
          opacity: 0,
          transform: 'translateY(-12px)',
        }),
        animate(
          '400ms cubic-bezier(0.25, 0.8, 0.25, 1)',
          style({
            opacity: 1,
            transform: 'translateY(0)',
          })
        ),
      ]),
      transition(':leave', [
        animate(
          '300ms cubic-bezier(0.25, 0.8, 0.25, 1)',
          style({
            opacity: 0,
            transform: 'translateY(-10px)',
          })
        ),
      ]),
    ]),
    trigger('questions', [
      transition(':enter', [style({ opacity: 1 })]),
      transition(':leave', [style({ opacity: 1 })]),
    ]),
  ],
})
export class OrderPaymentInternationalSitesComponent
  implements OnInit, OnDestroy
{
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetCountry: boolean = false;
  isLoadingGetStatic: boolean = true;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetAddress: boolean = false;
  isLoadingGetUnits: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isShowOrder: boolean = true;
  data: UserProfile;
  totalQuestionRecord: number = 0;
  timeout = null;
  fixedEffectiveAmount: number = null;
  isShowFixedEffectiveAmount: boolean;
  staticData: IStatic;
  isDesktop: boolean;
  dataPrice: PaymentInternationalSitesPriceModel;
  model: PaymentInternationalSitesSaveModel =
    new PaymentInternationalSitesSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;
  progress: number = 0;
  orderType: string;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  displayModal: boolean = false;
  imageId: string;
  isPageLoading: boolean = false;
  private destroyed$ = new Subject<void>();
  private isActive = true;
  private priceRequestSub: Subscription | null = null;
  private timeoutHandle: any = null;
  dataUser: UserProfile;
  isVerifiedInfo: boolean = false;
  errMsg: any;
  animationState = 'out';
  notRequiredTypes = [
    '972',
    '973',
    '974',
    '975',
    '976',
    '977',
    '978',
    '923',
    '924',
    '925',
    '983',
    '984',
    '985',
    '986',
    '987',
    '988',
    '989',
    '990',
    '991',
    '992',
    '993',
    '994',
    '995',
    '40806',
    '40807',
  ];
  noCurrencySelectOrderTypes = [
    '972',
    '973',
    '974',
    '975',
    '976',
    '977',
    '978',
  ];
  embassyOrderTypes = ['919', '920', '921', '922', '926', '927', '949'];
  isPhysical: boolean = false;
  amazonOrders = ['40802', '40803', '40804', '40805'];
  dataWeightUnits: IWeightUnits[] = [];
  selectedUnit: IWeightUnits;
  dataUserAddress: IUserAddress[] = [];
  selectedAddress: IUserAddress = null;
  styleClass: string = 'selectAddressModal';
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  @ViewChild('amountInput') amountInputRef!: ElementRef;
  @ViewChild('amountInputFixed') amountInputFixedRef!: ElementRef;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    public _orderTypeStore: OrderTypeStore,
    public dialogService: DialogService,
    private _translateService: TranslateService
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          const newOrderType = event.url.split('/')[4];
          if (newOrderType && newOrderType !== this.orderType) {
            if (this.dataSetting) {
              this.dataSetting.notificationListBeforeSave = null;
            }
            this.imageId = null;
            this.handleChangeRoute(newOrderType);
          }
        }
      }
    });
  }

  weightFieldsValid(): boolean {
    const isAmazonOrder = this.amazonOrders?.includes(this.orderType);
    if (!isAmazonOrder) return true;

    const hasUnit = this.selectedUnit && this.selectedUnit.staticId;
    const hasWeight =
      this.model.weight !== null && this.model.weight !== undefined;
    if (!hasUnit || !hasWeight) {
      return false;
    }
    const hasAddress = this.selectedAddress && this.selectedAddress.addressId;
    if (!hasAddress) return false;

    return true;
  }

  ngOnInit(): void {
    this.clearState();
    this._activatedRoute.params
      .pipe(takeUntil(this.destroyed$))
      .subscribe((params) => {
        this.onRouteParamChanged(params);
      });
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.orderType = this._activatedRoute.snapshot.params['orderType'];
    if (this.orderType === '176') {
      if (Math.random() < 0.5) {
        this._router.navigateByUrl(
          '/dashboard/services/internationalPaymentb/176'
        );
        return;
      }
    }
    this.handleChangeRoute(this.orderType);
    this.cdr.detectChanges();
  }

  private onRouteParamChanged(params: any) {
    if (this.timeoutHandle) {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
    }
    if (this.priceRequestSub) {
      this.priceRequestSub.unsubscribe();
      this.priceRequestSub = null;
    }
  }

  get isRequiredForThisOrderType(): boolean {
    return !(
      this.notRequiredTypes.includes(this.orderType) ||
      this.amazonOrders.includes(this.orderType)
    );
  }

  ngOnDestroy() {
    this.isActive = false;
    this.destroyed$.next();
    this.destroyed$.complete();

    if (this.timeoutHandle) {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
    }
    if (this.priceRequestSub) {
      this.priceRequestSub.unsubscribe();
      this.priceRequestSub = null;
    }
    if (this.subscriptions) {
      this.subscriptions.unsubscribe();
      this.subscriptions = new Subscription();
    }
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  handleChangeRoute(e: string) {
    this.clearState();
    setTimeout(() => {
      this.clearAmountInput();
    });

    this.isPageLoading = true;
    this.orderType = e;
    if (stringIsEmptyOrNull(this.orderType)) {
      this.isPageLoading = false;
      this.cdr.detectChanges();
    } else {
      this.getStaticById();
    }
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: Number(this.orderType),
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.isPageLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
              this.inquiry();
            }

            if (response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (this.dataCurrency && this.dataCurrency.length == 1) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    if (this.priceRequestSub) {
      this.priceRequestSub.unsubscribe();
      this.priceRequestSub = null;
    }
    const amount = Number(this.model?.amount);
    if (!(this.selectedCurrency && Number.isFinite(amount) && amount >= 0)) {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
      return;
    }

    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.weightType = this.selectedUnit?.staticId;
    this.model.addressId = this.selectedAddress?.addressId;
    this.model.orderType = this.orderType;

    this.priceRequestSub = this._commonService
      .put(Address.PaymentInternationalSitesGetPrice, this.model, false)
      .pipe(
        finalize(() => {
          this.isLoadingGetPrice = false;
          this.cdr.detectChanges();
        })
      )
      .subscribe(
        (response: response) => {
          this.dataPrice = response.data;
          this.inquiryIsOk = true;
          this.cdr.detectChanges();
        },
        (error) => {
          this.dataPrice = null;
          this.inquiryIsOk = false;
        }
      );
  }

  modalSelectAddress(): DynamicDialogRef {
    const ref = this.dialogService.open(SelectAddressModalComponent, {
      header:
        this._translateService.translations[this._translateService.currentLang][
          'selectAddress'
        ],
      styleClass: this.styleClass,
      data: {
        msg: this.errMsg,
      },
      dismissableMask: true,
    });

    ref.onClose.subscribe((returnedAddressId: any) => {
      if (returnedAddressId) {
        this.getAddress(returnedAddressId);
      } else {
        this.getAddress();
      }
    });
    return ref;
  }

  getAddress(selectIdAfterLoad?: string | number): void {
    this.isLoadingGetAddress = true;

    const sub = this._commonService
      .put(Address.UserAddressGet, {})
      .pipe(
        finalize(() => {
          this.isLoadingGetAddress = false;
          this.cdr.detectChanges();
        })
      )
      .subscribe(
        (response: any) => {
          if (response && response.data) {
            this.dataUserAddress = response.data;

            if (selectIdAfterLoad) {
              const found = this.dataUserAddress.find(
                (a) => String(a.addressId) === String(selectIdAfterLoad)
              );
              if (found) {
                this.selectedAddress = found;
              } else if (this.dataUserAddress.length > 0) {
                this.selectedAddress = this.dataUserAddress[0];
              } else {
                this.selectedAddress = null;
              }
            } else {
              this.selectedAddress =
                this.dataUserAddress.length > 0
                  ? this.dataUserAddress[0]
                  : null;
            }
          } else {
            this.dataUserAddress = [];
            this.selectedAddress = null;
          }
          this.cdr.detectChanges();
        },
        (err) => {}
      );

    this.subscriptions.add(sub);
  }

  getWeightUnits() {
    this.subscriptions = new Subscription();
    this.isLoadingGetUnits = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.Static, { parentId: 42000 })
        .pipe(
          finalize(() => {
            this.isLoadingGetUnits = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response) {
              this.dataWeightUnits = response.data;
              this.selectedUnit = this.dataWeightUnits[0];
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getStaticById() {
    this.subscriptions.unsubscribe();
    this.subscriptions = new Subscription();
    this.isLoadingGetAddress = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.orderType),
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            if (this.orderType) {
              if (
                this.amazonOrders.includes(this.orderType) &&
                this.model.isWeightFee
              ) {
                this.getWeightUnits();
                this.getAddress();
              }
            }
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response) {
              this.staticData = response.data;
              this.getFullOrder();
            }
            if (
              this.staticData &&
              this.staticData.fixedEffectiveAmount != null &&
              this.staticData.fixedEffectiveAmount != undefined
            ) {
              this.fixedEffectiveAmount = this.staticData.fixedEffectiveAmount;
              this.model.amount = this.fixedEffectiveAmount.toString();
              this.inquiry();
            } else if (this.staticData.fixedEffectiveAmount === 0) {
              this.model.amount = '0';
              this.inquiry();
            }

            if (this.staticData && this.staticData.isShowFixedEffectiveAmount) {
              this.isShowFixedEffectiveAmount =
                this.staticData.isShowFixedEffectiveAmount;
            }
            if (this.staticData && this.staticData.imageId) {
              this.loadFilesStaticImage(this.staticData.imageId);
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  additionalFieldsValid(): boolean {
    if (!this.additionalFiels.length) return true;
    let isValid = true;
    this.additionalFiels.forEach((field) => {
      if (
        !field.isDeleted &&
        (field.persianName?.trim() || field.englishName?.trim()) &&
        field.required === true &&
        (!field.value || String(field.value).trim() === '')
      ) {
        isValid = false;
      }
    });
    return isValid;
  }

  loadFilesStaticImage(id: string) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.staticData.fileUrl = response;
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  inquiry() {
    if (this.timeoutHandle) {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
    }
    this.model.weightType = this.selectedUnit?.staticId;
    const amountRaw = this.model?.amount;
    const amount =
      amountRaw === '' || amountRaw === null || amountRaw === undefined
        ? NaN
        : Number(amountRaw);

    const hasValidAmount = Number.isFinite(amount) && amount >= 0;
    const hasCurrency =
      this.selectedCurrency && this.selectedCurrency.currencyId;

    if (!this.isActive) {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
      return;
    }

    if (hasCurrency && hasValidAmount) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeoutHandle = setTimeout(() => {
        this.timeoutHandle = null;
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.inquiryIsOk = false;
      this.cdr.detectChanges();
    }
  }

  private clearState(): void {
    this.model = new PaymentInternationalSitesSaveModel();
    this.dataPrice = null;
    this.url = null;
    this.file = null;
    this.progress = 0;
    this.extensionStore = null;
    this.inquiryIsOk = false;
    this.dataCurrency = [];
    this.selectedCurrency = null;
    this.selectedUnit = null;
    this.selectedAddress = null;
    this.dataSteps = [];
    this.staticData = null;
    this.additionalFiels = [];
    this.dataQuestion = [];
    this.dataSetting = null;
    this.dataStatic = null;
    this.totalRecord = 0;
    this.imageId = null;
    this.fixedEffectiveAmount = null;
    this.isShowFixedEffectiveAmount = null;

    if (this.appChildComponent && this.appChildComponent.formAttr) {
      this.appChildComponent.formAttr.reset();
    }

    this.cdr.detectChanges();
  }

  private clearAmountInput(): void {
    this.model.amount = null;
    this.fixedEffectiveAmount = null;

    if (this.amountInputRef?.nativeElement) {
      this.amountInputRef.nativeElement.value = '';
    }

    if (this.amountInputFixedRef?.nativeElement) {
      this.amountInputFixedRef.nativeElement.value = '';
    }
  }

  submit() {
    if (
      !isUrlValid(this.model.pageAddress) &&
      !this.notRequiredTypes.includes(this.orderType)
    ) {
      this._alert.warning('لطفا آدرس صفحه ورود را بدرستی وارد نمایید');
      this.model.pageAddress = null;
      return;
    }
    if (this.isRequiredForThisOrderType) {
      if (!this.model.userName || !this.model.password) {
        this._alert.warning(
          'لطفاً از پر کردن تمام بخش‌های ستاره‌دار مطمئن شوید.'
        );
        return;
      }
    }
    if (!this.weightFieldsValid()) {
      this._alert.warning(
        'لطفا از پر بودن تمامی فیلدهای ستاره‌‌دار مرتبط با محصول فیزیکی مطمئن شوید.'
      );
      return;
    }
    if (!this.additionalFieldsValid()) {
      this._alert.warning('لطفا از پر کردن تمام بخش‌های ستاره دار مطمئن شوید.');
      return;
    }

    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }

    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency?.currencyId;
    this.model.addressId = this.selectedAddress?.addressId;
    this.model.weightType = this.selectedUnit?.staticId;
    this.model.orderType = this.orderType;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.PaymentInternationalSitesSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._orderTypeStore.orderTypeBehavior.next(
              this.orderType.toString()
            );
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            const orderType = this._activatedRoute.snapshot.params['orderType'];
            if (orderType === '176') {
              const currentUrl = this._router.url;
              const hasB = currentUrl.includes('internationalPaymentb');

              const redirectUrl =
                '/dashboard/checkouts/internationalpayment/' +
                response.data.orderId;
              this._router.navigateByUrl(redirectUrl);
            } else {
              this._router.navigateByUrl(
                '/dashboard/checkouts/internationalpayment/' +
                  response.data.orderId
              );
            }
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
