import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PaymentInternationalSitesPlanBComponent } from './paymentInternationalSitesPlanB.component';
const routes: Routes = [
  {
    path: '',

    component: PaymentInternationalSitesPlanBComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید از سایت‌های خارجی',
          url: '/dashboard/Cat/internationalPayment',
        },
      ],
    },
    children: [
      {
        data: { title: 'پرداخت‌های خارجی' },
        path: ':orderType',
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPaymentInternationalSitesPlanBModule
          ),
      },
      {
        data: { title: 'پرداخت‌های خارجی' },
        path: ':orderType/:language',
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPaymentInternationalSitesPlanBModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PaymentInternationalSitesPlanBRoutingModule {}
