import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { LegalOrderComponent } from '../../components/legal-order/legal-order.component';
import { DeviceDetectorService } from 'ngx-device-detector';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { ApplicationFeeSaveGroupModel } from 'src/app/core/params/order/ApplicationFeeSaveGroupModel';
import { FileUploadService } from '@services/fileUpload.service';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { PaypalRechargeSaveModel } from 'src/app/core/params/order/PaypalRechargeSaveModel';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { DialogService } from 'primeng/dynamicdialog';
import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-pay-pal',
  templateUrl: './paypalRecharge.component.html',
  styleUrls: ['./paypalRecharge.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class PaypalRechargeComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  isDesktop: boolean;
  emailPaypal: string;
  customerDescription: string;
  isShowOrder: boolean = true;
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  url: string = null;
  file: File;
  timeout = null;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 910;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isLoadingGetFullOrder: boolean;
  isLoadingGetType: boolean;
  isLoadingGetPrice: boolean;
  inquiryIsOk: boolean = false;
  dataPrice: any;
  limitNumber: number;
  model: PaypalRechargeSaveModel = new PaypalRechargeSaveModel();
  isValidLegalForm: boolean = true;
  finalAmount: any;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  imageId: string;
  displayModal: boolean = false;
  dataUser: UserProfile;
  errMsg: any;
  isVerifiedInfo: boolean = false;

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;

  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private _router: Router,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  ngOnInit(): void {
    this.model.orderType = '910';
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });

    this.getFullOrder();
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    if (
      this.model.payPalAccount &&
      (this.model.payPalAccount != null || this.model.payPalAccount != '')
    ) {
      this.isLoading = true;
      this.model.currencyId = this.selectedCurrency.currencyId;
      this.cdr.detectChanges();
      this.subscriptions.add(
        this._commonService
          .post(Address.OrderPaypalAccountRechargeSave, this.model, false)
          .pipe(
            finalize(() => {
              this.isLoading = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response: response) => {
              this._alert.success(
                this._translateService.translations[
                  this._translateService.currentLang
                ]['checkoutSubmittedSuccesfully']
              );
              this._router.navigateByUrl(
                '/dashboard/checkouts/paypal-recharge/' + response.data.orderId
              );
            },
            (error) => {
              this.errMsg = error.status;
              if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
                setTimeout(() => {
                  this.orderVerify.modalGetMobile();
                }, 200);
              }
            }
          )
      );
    } else {
      this._alert.warning('ایمیل حساب پی پال اجباریست');
    }
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaypalAccountRechargeGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.finalAmount = response.data.finalAmount;

            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.model.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;

              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;
              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }

            this.model.currencyId = this.selectedCurrency.currencyId;
            if (
              !isNaN(Number(this.model.amount)) &&
              Number(this.model.amount) > 0
            ) {
              this.getPrice();
              this.cdr.detectChanges();
            }
          },
          (error) => {}
        )
    );
  }

  fileChange(event, item: ApplicationFeeSaveGroupModel = null) {
    if (item == null) {
      let fileList: FileList =
        event.target != undefined && event.target != null
          ? event.target.files
          : event;
      if (fileList.length > 0) {
        this.file = fileList[0];
        this.fileUpload();
      }
    } else {
      let fileList: FileList =
        event.target != undefined && event.target != null
          ? event.target.files
          : event;
      if (fileList.length > 0) {
        this.file = fileList[0];
        this.fileUpload(item);
      }
    }
  }

  fileUpload(item: ApplicationFeeSaveGroupModel = null) {
    this.cdr.detectChanges();
    if (item == null) {
      this.isLoadingFile = true;
      this.subscriptions.add(
        this._fileUploadService
          .fileUpload(this.file.name, this.file, Address.FileUploadBig)
          .subscribe((event: HttpEvent<any>) => {
            switch (event.type) {
              case HttpEventType.Sent:
                break;
              case HttpEventType.ResponseHeader:
                break;
              case HttpEventType.UploadProgress:
                var eventTotal = event.total ? event.total : 0;
                this.progress = Math.round((event.loaded / eventTotal) * 100);
                this.cdr.detectChanges();
                break;
              case HttpEventType.Response:
                if (event.body['data'] != null) {
                  this.model.fileId = event.body['data'];
                  this.loadFiles(event.body['data']);
                  this.isLoadingFile = false;
                  this.cdr.detectChanges();
                }
                setTimeout(() => {
                  this.progress = 0;
                  this.cdr.detectChanges();
                }, 1500);
            }
          })
      );
    } else {
      item.isLoadingFile = true;
      this.subscriptions.add(
        this._fileUploadService
          .fileUpload(this.file.name, this.file, Address.FileUploadBig)
          .subscribe((event: HttpEvent<any>) => {
            switch (event.type) {
              case HttpEventType.Sent:
                break;
              case HttpEventType.ResponseHeader:
                break;
              case HttpEventType.UploadProgress:
                var eventTotal = event.total ? event.total : 0;
                item.progress = Math.round((event.loaded / eventTotal) * 100);
                this.cdr.detectChanges();
                break;
              case HttpEventType.Response:
                if (event.body['data'] != null) {
                  item.fileId = event.body['data'];
                  this.loadFiles(item.fileId, item);
                  item.isLoadingGetFile = false;
                  this.cdr.detectChanges();
                }
                setTimeout(() => {
                  item.progress = 0;
                  this.cdr.detectChanges();
                }, 1500);
            }
          })
      );
    }
  }

  loadFiles(id: string, item: ApplicationFeeSaveGroupModel = null) {
    this.cdr.detectChanges();
    if (item == null) {
      this.isLoadingGetFile = true;
      this.isLoadingFile = true;
      this.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              this.isLoadingFile = false;
              this.isLoadingGetFile = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              this.url = response;

              this.cdr.detectChanges();
            },
            (err: any) => {},
            () => {}
          )
      );
    } else {
      item.isLoadingGetFile = true;
      item.isLoadingFile = true;
      this.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              item.isLoadingFile = false;
              item.isLoadingGetFile = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              item.url = response;

              this.cdr.detectChanges();
            },
            (err: any) => {},
            () => {}
          )
      );
    }
  }
  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
