import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PaypalComponent } from './paypal.component';

const routes: Routes = [
  {
    path: '',
    component: PaypalComponent,
    data: {
      title: 'پی پال',
      breadcrumb: [{ title: 'پی پال', url: '/dashboard/Cat/paypal' }],
    },
    children: [
      {
        path: 'accountRecharge',

        loadChildren: () =>
          import('./paypal-recharge/paypalRecharge.module').then(
            (m) => m.PaypalRechargeModule
          ),
      },
      {
        path: 'accountRecharge/:language',

        loadChildren: () =>
          import('./paypal-recharge/paypalRecharge.module').then(
            (m) => m.PaypalRechargeModule
          ),
      },
      {
        path: 'sell',

        loadChildren: () =>
          import('./sell-paypal/paypalSell.module').then(
            (m) => m.PaypalSellModule
          ),
      },
      {
        path: 'sell/:language',

        loadChildren: () =>
          import('./sell-paypal/paypalSell.module').then(
            (m) => m.PaypalSellModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PaypalRoutingModule {}
