import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { LegalOrderComponent } from '../../components/legal-order/legal-order.component';
import { DeviceDetectorService } from 'ngx-device-detector';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { PaypalSellSaveModel } from 'src/app/core/params/order/PaypalSellSaveModel';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { UserProfile } from '@interfaces/user/userProfile';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-paypal-sell',
  templateUrl: './paypalSell.component.html',
  styleUrls: ['./paypalSell.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class PaypalSellComponent implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  isDesktop: boolean;
  isShowOrder: boolean = true;
  emailPaypal: string;
  customerDescription: string;
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  url: string = null;
  file: File;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 171;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isLoadingGetFullOrder: boolean;
  isLoadingGetPrice: boolean;
  inquiryIsOk: boolean = false;
  dataPrice: any;
  model: PaypalSellSaveModel = new PaypalSellSaveModel();
  isValidLegalForm: boolean = true;
  finalAmount: any;
  timeout = null;
  limitNumber: number;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  displayModal: boolean = false;
  minimumPurchaseValue: any;
  accountType = [
    { title: 'Friends and Family', value: 521 },
    { title: 'Goods and Service', value: 522 },
  ];
  imageId: string;
  dataUser: UserProfile;
  errMsg: any;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  isVerifiedInfo: boolean = false;
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;

  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public _deviceDetectorService: DeviceDetectorService,
    private _router: Router,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore,
    private _orderTypeStore: OrderTypeStore
  ) {}

  ngOnInit(): void {
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.getFullOrder();

    this.cdr.detectChanges();
  }

  hideAlarmOrder() {
    this.isVerifiedInfo = true;
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.finalAmount = this.model.amount;
      this.cdr.detectChanges();
    }
  }

  getPrice() {
    if (this.model.accountType == 522) {
      this.model.orderType = '171';
    } else {
      this.model.orderType = '940';
    }
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaypalSellGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.finalAmount = response.data.finalAmount;

            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }

              if (response.data.setting.data.minimumNumberPurchase) {
                this.minimumPurchaseValue =
                  response.data.setting.data.minimumNumberPurchase;
              }
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.OrderPaypalSellSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-sell/' + response.data.orderId
            );
            this._orderTypeStore.orderType.next(this.model.orderType);
            this._orderTypeStore.orderTypeBehavior.next(this.model.orderType);
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }
  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
  onDialogHide() {
    this.displayModal = false;
  }
}
