import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PerfectMoneyBuyingComponent } from './perfectMoneyBuying.component';

const routes: Routes = [
  {
    path: '',
    component: PerfectMoneyBuyingComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید پرفکت مانی',
          url: '/dashboard/services/perfectmoney/buy',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPerfectMoneyBuyingModule
          ),
      },
      {
        path: ':language',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPerfectMoneyBuyingModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PerfectMoneyBuyingRoutingModule {}
