import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PerfectmoneyComponent } from './perfectmoney.component';

const routes: Routes = [
  {
    path: '',
    component: PerfectmoneyComponent,
    data: {
      title: 'پرفکت مانی',
      breadcrumb: [{ title: 'پرفکت مانی', url: '/dashboard/Cat/perfectmoney' }],
    },
    children: [
      {
        path: 'buyVoucher',

        loadChildren: () =>
          import('./voucherPerfectMoneyBuy/voucherPerfectMoney.module').then(
            (m) => m.VoucherPerfectMoneyModule
          ),
      },
      {
        path: 'buyVoucher/:language',

        loadChildren: () =>
          import('./voucherPerfectMoneyBuy/voucherPerfectMoney.module').then(
            (m) => m.VoucherPerfectMoneyModule
          ),
      },

      {
        path: 'buy',

        loadChildren: () =>
          import('./perfectMoneyBuying/perfectMoneyBuying.module').then(
            (m) => m.PerfectMoneyBuyingModule
          ),
      },
      {
        path: 'buy/:language',

        loadChildren: () =>
          import('./perfectMoneyBuying/perfectMoneyBuying.module').then(
            (m) => m.PerfectMoneyBuyingModule
          ),
      },
      {
        path: 'sell',

        loadChildren: () =>
          import('./sellingPerfectMoney/sellingPerfectMoney.module').then(
            (m) => m.SellingPerfectMoneyModule
          ),
      },
      {
        path: 'sell/:language',

        loadChildren: () =>
          import('./sellingPerfectMoney/sellingPerfectMoney.module').then(
            (m) => m.SellingPerfectMoneyModule
          ),
      },

      {
        path: 'sellVoucher',

        loadChildren: () =>
          import(
            './voucherPerfectMoneySell/voucherPerfectMoneySell.module'
          ).then((m) => m.VoucherPerfectMoneySellModule),
      },
      {
        path: 'sellVoucher/:language',

        loadChildren: () =>
          import(
            './voucherPerfectMoneySell/voucherPerfectMoneySell.module'
          ).then((m) => m.VoucherPerfectMoneySellModule),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PerfectmoneyRoutingModule {}
