import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
} from '@angular/core';
import { scrollTop } from '@helpers/window.helper';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';
@Component({
  selector: "app-Voucher-PerfectMoney",
  templateUrl: "./voucherPerfectMoney.component.html",
  styleUrls: ["./voucherPerfectMoney.component.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class VoucherPerfectMoneyComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();

  constructor(
  ) {}

  ngOnInit(): void {}
  ngAfterViewInit() {}
  onActivate(event) {
    scrollTop();
 }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
