import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { RevoloutComponent } from './revolout.component';

const routes: Routes = [
  {
    path: '',
    component: RevoloutComponent,
    data: {
      title: 'رولوت',
      breadcrumb: [{ title: 'رولوت', url: '/dashboard/Cat/revolut' }],
    },
    children: [
      {
        path: 'sell',

        loadChildren: () =>
          import('./revoloutSell/revoloutSell.module').then(
            (m) => m.RevoloutSellModule
          ),
      },
      {
        path: 'sell/:language',

        loadChildren: () =>
          import('./revoloutSell/revoloutSell.module').then(
            (m) => m.RevoloutSellModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class RevoloutRoutingModule {}
