import {
  Component,
  OnDestroy,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from "@angular/core";
import { Subscription } from "rxjs";
import { fadeAnimation } from "src/app/core/animations/animations";
import { scrollTop } from "@helpers/window.helper";
@Component({
  selector: "app-revoloutSell",
  templateUrl: "./revoloutSell.component.html",
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class RevoloutSellComponent
  implements OnDestroy
{
  subscriptions = new Subscription();

  constructor(
    private cdr: ChangeDetectorRef,
  ) {this.cdr;}

  onActivate(event) {
    scrollTop();
 }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
