import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { IncomeCashOrderComponent } from './incomeCashOrder.component';
const routes: Routes = [
  {
    path: '',

    component: IncomeCashOrderComponent,

    children: [
      {
        data: { title: 'نقد درآمد ارزی' },
        path: ':orderType',
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderIncomeCashModule),
      },
      {
        data: { title: 'نقد درآمد ارزی' },
        path: ':orderType/:language',
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderIncomeCashModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class IncomeCashOrderRoutingModule {}
