import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { Subscription } from 'rxjs';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Component({
  selector: 'app-incomeCash-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class OrderIncomeCashComponent
  implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  constructor(
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _activatedRoute: ActivatedRoute,
  ) {}

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/incomecash/' +
        this._activatedRoute.snapshot.params['language']
      );
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}