import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { GiftCardComponent } from './giftCard.component';
const routes: Routes = [
  {
    path: '',

    component: GiftCardComponent,
    data: {
      breadcrumb: [
        {
          title: 'گیفت کارت ',
          url: '/dashboard/services/giftcard',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: ':orderType',
        data: { title: 'گیفت کارت ' },
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderGiftCardModule),
      },

      {
        path: ':orderType/:language',
        data: { title: 'گیفت کارت' },
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderGiftCardModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class GiftCardRoutingModule {}
