import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ElementRef,
ViewChild,
  OnChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';

import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { GiftCardPriceModel } from '@models/orders/GiftCardPriceModel';

import { GiftCardTypeModel } from '@models/orders/GiftCardTypeModel';
import { IGiftCardType } from '@interfaces/orders/iGiftCardType';
import { DeviceDetectorService } from 'ngx-device-detector';
import { GiftCardSaveModel } from 'src/app/core/params/order/GiftCardSaveModel';

import { DialogService } from 'primeng/dynamicdialog';
import { OrderGiftcardModalComponent } from '../../orderGiftCardModal/orderGiftCardModal.component';
import { CountryModel } from '@models/orders/CountryModel';

@Component({
  selector: 'form-giftCard',
  templateUrl: './formGiftCard.component.html',
  styleUrls: ['./formGiftCard.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormGiftCardComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges
{
  subscriptions = new Subscription();

  isLoadingGetGiftCardType: boolean = false;
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;

  inquiryIsOk: boolean = false;
  dataGiftCardType: IGiftCardType[] = [];

  selectedCurrency: CountryModel;
  selectedGiftCardType: GiftCardTypeModel;
  data: UserProfile;
  giftCardType: string;
  isLoadingFile: boolean = false;
  timeout = null;
  isDesktop: boolean = false;
  dataPrice: GiftCardPriceModel;
  model: GiftCardSaveModel = new GiftCardSaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = true;
  totalQuestionRecord: number = 0;
  limitNumber: number;
  isLoadingLimitaion: boolean = false;
  keyValues: string;
  orderType: string;
  indexTab: string;
  activeIndex: number = 0;
  fileUrl: string;

  index: number = 0;
  dataCountry: CountryModel[] = [];

  objectImageIds = { giftCard: [], country: [] };
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    public dialogService: DialogService
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          this.handleChangeRoute(event.url.split('/')[4]);
        }
      }
    });
  }

  ngOnInit() {
    this.handleChangeRoute(this._activatedRoute.snapshot.params['orderType']);
    this.isDesktop = this._deviceDetectorService.isDesktop();

    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  ngOnChanges() {}

  handleChangeRoute(e: string) {
    this.orderType = e;
    this.getCurrency();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    this.cdr.detectChanges();
  }

  OnInputCheck() {}

  getCurrency() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.GiftCardTypeGetLisCountry,
          { orderType: this.orderType, useInOrder: true, useInRegister: false },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCountry = response.data;
            for (let country of this.dataCountry) {
              this.objectImageIds.country.push(country.imageIdCountry);
            }
            this.checkCurrencyForImage();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
  createGroupIdString(theList) {
    let groupedIds = '';
    for (let i = 1; i <= theList.length - 1; i++) {
      if (theList[i] && theList[i] != null) {
        groupedIds = groupedIds + theList[i] + '&';
      }
    }

    groupedIds = groupedIds + theList[0];

    return groupedIds;
  }
  checkCurrencyForImage() {
    let groupedIds = this.createGroupIdString(this.objectImageIds.country);

    this.loadCurrencyImg(groupedIds, this.dataCountry);
  }

  getGiftCardType(item: CountryModel = null) {
    this.isLoadingGetGiftCardType = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.GiftCardTypeGetList,
          {
            orderType: this.orderType,
            countryId: item.countryId,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetGiftCardType = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataGiftCardType = response.data;
            for (let gfc of this.dataGiftCardType) {
              this.objectImageIds.giftCard.push(gfc.imageId);
            }
            this.checkForImage();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  checkForImage() {
    let groupedIds = this.createGroupIdString(this.objectImageIds.giftCard);
    this.loadGfcImg(groupedIds, this.dataGiftCardType);
  }

  loadCurrencyImg(groupedIds: string, item: CountryModel[]) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.GetFileUrlGroup, { ids: groupedIds })
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            let listUrlsImageCountry = response;

            for (let itemUrl of listUrlsImageCountry) {
              for (let country of item) {
                if (country.imageIdCountry === itemUrl.fileId) {
                  country.fileUrl = itemUrl.url;
                }
              }
            }

            if (this.dataCountry && this.dataCountry.length > 0) {
              this.selectedCurrency = this.dataCountry[0];
              this.activeIndex = 0;
              this.selectedCurrency.active = true;

              this.getGiftCardType(this.selectedCurrency);
            }
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  loadGfcImg(groupedIds: string, item: GiftCardTypeModel[]) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.GetFileUrlGroup, { ids: groupedIds })
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            let listUrlsImageCountry = response;

            for (let itemUrl of listUrlsImageCountry) {
              for (let gfc of item) {
                if (gfc.imageId === itemUrl.fileId) {
                  gfc.fileUrl = itemUrl.url;
                }
              }
            }

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  loadGiftcardModal(item: any = null) {
    const ref = this.dialogService.open(OrderGiftcardModalComponent, {
      header: '',
      height: '60%',
      width: '30%',
      styleClass: 'gfc-modal',
      dismissableMask: true,
      data: {
        fileUrl: item.fileUrl,
        title: item.title,
        orderType: this.orderType,
        giftCardTypeId: item.giftCardTypeId,
        currencyId: item.currencyId,
        price: item.price,
      },
    });
    ref.onClose.subscribe((model: any) => {});
  }
}
