import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subject, Subscription, takeUntil } from 'rxjs';
import { response } from '@interfaces/response';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { PermiumAccountSaveModel } from 'src/app/core/params/order/PermiumAccountsaveModel';
import { PermiumTypeGet } from '@models/orders/permiumTypeGet';
import { PermiumActivationGet } from '@models/orders/permiumActivationGet';
import { PermiumPeriodGet } from '@models/orders/permiumPeriodGet';
import { PermiumPlanGet } from '@models/orders/permiumPlanGet';
import { PermiumLanguageGet } from '@models/orders/permiumLanguageGet';
import { PermiumCountryGet } from '@models/orders/permiumCountyGet';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { FullResponsePremiumGetModel } from '@models/orders/FullResponsePremiumGetModel';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { MenuItem } from 'primeng/api';
import { ViewportScroller } from '@angular/common';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { PremiumAccountPriceModel } from '@models/orders/prpremiumAccountPriceModelPriceModel';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'form-permium',
  templateUrl: './formPermium.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormPermiumComponent implements OnInit, OnDestroy {
  subscriptions = new Subscription();
  isLoadingGetPrice: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  isValidLegalForm: boolean = true;
  isLoadingFile: boolean = false;
  timeout = null;
  isDesktop: boolean = false;
  dataPrice: PremiumAccountPriceModel;
  model: PermiumAccountSaveModel = new PermiumAccountSaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = true;
  totalQuestionRecord: number = 0;
  limitNumber: number;
  isLoadingLimitaion: boolean = false;
  getTotalAmountLoading: boolean = false;
  displayModal: boolean = false;
  keyValues: string;
  orderType: any;
  indexTab: string;
  staticTitle: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  requiredStatus: boolean;
  isRequiredExist: boolean;
  selectedCurrency: CurrencyModel = new CurrencyModel();
  isLoadingGetStatic: boolean = true;
  dataPermiumType: PermiumTypeGet[] = [];
  selectedPermiumType: PermiumTypeGet = new PermiumTypeGet();
  dataPermiumActivation: PermiumActivationGet[] = [];
  selectedPermiumActivation: PermiumActivationGet = new PermiumActivationGet();
  dataPermiumPeriod: PermiumPeriodGet[] = [];
  selectedPermiumPeriod: PermiumPeriodGet = new PermiumPeriodGet();
  fixedEffectiveAmount: number;
  dataPermiumPlan: PermiumPlanGet[] = [];
  selectedPermiumPlan: PermiumPlanGet = new PermiumPlanGet();
  dataPermiumLanguage: PermiumLanguageGet[] = [];
  selectedPermiumLanguage: PermiumLanguageGet = new PermiumLanguageGet();
  dataPermiumCountry: PermiumCountryGet[] = [];
  selectedPermiumCountry: PermiumCountryGet = new PermiumCountryGet();
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataSteps: MenuItem[] = [];
  dataStatic: any;
  imageId: string;
  totalCurrencyAmount: number;
  mark: string;
  errMsg: any;
  isVerifiedInfo: boolean = false;
  isLoadingGetFullResponse: boolean;
  fullPremiumResponse: FullResponsePremiumGetModel =
    new FullResponsePremiumGetModel();
  isShowFixedEffectiveAmount: boolean;
  isPageLoading: boolean = false;
  private destroyed$ = new Subject<void>();
  private priceRequestSub: Subscription | null = null;
  private timeoutHandle: any = null;

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          const newOrderType = event.url.split('/')[4];
          if (newOrderType && newOrderType !== this.orderType) {
            this.dataPermiumActivation = [];
            this.dataPermiumCountry = [];
            this.dataPermiumLanguage = [];
            this.dataPermiumPeriod = [];
            this.dataPermiumPlan = [];
            this.dataPermiumType = [];
            this.dataSetting.notificationListBeforeSave = null;
            this.imageId = null;
            this.handleChangeRoute(newOrderType);
          }
        }
      }
    });
  }

  ngOnInit() {
    this.clearState();
    this._activatedRoute.params
      .pipe(takeUntil(this.destroyed$))
      .subscribe((params) => {
        this.onRouteParamChanged(params);
      });
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.model.count = 1;
    this.handleChangeRoute(this._activatedRoute.snapshot.params['orderType']);
    this.cdr.detectChanges();
  }

  private onRouteParamChanged(params: any) {
    if (this.timeoutHandle) {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
    }
    if (this.priceRequestSub) {
      this.priceRequestSub.unsubscribe();
      this.priceRequestSub = null;
    }
  }

  handleChangeRoute(e: string) {
    this.clearState();
    this.isPageLoading = true;
    this.orderType = e;
    if (stringIsEmptyOrNull(this.orderType)) {
      this.isPageLoading = false;
      this.cdr.detectChanges();
    } else {
      this.getStaticById();
    }
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    if (this.timeout) {
      clearTimeout(this.timeout);
      this.timeout = null;
    }
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getPremiumAccountFull() {
    this.isLoadingGetFullResponse = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.FullPremiumAccount,
          {
            orderType: Number(this.orderType),
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullResponse = false;
            this.isPageLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.fullPremiumResponse = response.data;
            if (
              this.fullPremiumResponse.activationType.data &&
              this.fullPremiumResponse.activationType.data.length > 0
            ) {
              this.dataPermiumActivation =
                this.fullPremiumResponse.activationType.data;

              this.selectedPermiumActivation = this.dataPermiumActivation[0];

              this.getCurrencyAmount(
                this.dataPermiumActivation,
                'activationType',
                this.selectedPermiumActivation
              );
            }

            if (
              this.fullPremiumResponse.country.data &&
              this.fullPremiumResponse.country.data.length > 0
            ) {
              this.dataPermiumCountry = this.fullPremiumResponse.country.data;
              this.selectedPermiumCountry = this.dataPermiumCountry[0];
              this.getCurrencyAmount(
                this.dataPermiumCountry,
                'country',
                this.selectedPermiumCountry
              );
            }

            if (
              this.fullPremiumResponse.language.data &&
              this.fullPremiumResponse.language.data.length > 0
            ) {
              this.dataPermiumLanguage = this.fullPremiumResponse.language.data;
              this.selectedPermiumLanguage = this.dataPermiumLanguage[0];
              this.getCurrencyAmount(
                this.dataPermiumLanguage,
                'language',
                this.selectedPermiumLanguage
              );
            }

            if (
              this.fullPremiumResponse.type.data &&
              this.fullPremiumResponse.type.data.length > 0
            ) {
              this.dataPermiumType = this.fullPremiumResponse.type.data;
              this.selectedPermiumType = this.dataPermiumType[0];
              this.getCurrencyAmount(
                this.dataPermiumType,
                'type',
                this.selectedPermiumType
              );
            }

            if (
              this.fullPremiumResponse.period.data &&
              this.fullPremiumResponse.period.data.length > 0
            ) {
              this.dataPermiumPeriod = this.fullPremiumResponse.period.data;
              this.selectedPermiumPeriod = this.dataPermiumPeriod[0];
              this.getCurrencyAmount(
                this.dataPermiumPeriod,
                'period',
                this.selectedPermiumPeriod
              );
            }

            if (
              this.fullPremiumResponse.pelan.data &&
              this.fullPremiumResponse.pelan.data.length > 0
            ) {
              this.dataPermiumPlan = this.fullPremiumResponse.pelan.data;
              this.selectedPermiumPlan = this.dataPermiumPlan[0];
              this.getCurrencyAmount(
                this.dataPermiumPlan,
                'pelan',
                this.selectedPermiumPlan
              );
            }

            if (
              this.fullPremiumResponse.currency.data &&
              this.fullPremiumResponse.currency.data.length > 0
            ) {
              this.dataCurrency = this.fullPremiumResponse.currency.data;
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (
              this.fullPremiumResponse.question.data &&
              this.fullPremiumResponse.question.data.length > 0
            ) {
              this.dataQuestion = this.fullPremiumResponse.question.data;
            }

            if (
              this.fullPremiumResponse.steps &&
              this.fullPremiumResponse.steps.data.length > 0
            ) {
              this.dataSteps = this.fullPremiumResponse.steps.data;
            }
            if (this.fullPremiumResponse.static.data) {
              this.dataStatic = this.fullPremiumResponse.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
                for (let item of this.additionalFiels) {
                  this.isRequiredExist = item.required || true;
                }
              }
              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
              this.staticTitle = this.dataStatic.title;
            }

            if (this.fullPremiumResponse?.setting?.data) {
              this.dataSetting = this.fullPremiumResponse.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }

            this.inquiry();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  onDropdownChange(data: any, field: string, selectedObject: any) {
    this.inquiry();
    this.getCurrencyAmount(data, field, selectedObject);
  }

  getCurrencyAmount(
    list: any[],
    field: string,
    idObject: Record<string, any> | null = null
  ): void {
    this.getTotalAmountLoading = true;
    this.cdr.detectChanges();
    if (!Array.isArray(list) || list.length === 0) {
      this.totalCurrencyAmount = 0;
      this.getTotalAmountLoading = false;
      this.cdr.detectChanges();
      return;
    }

    const idFieldMap: Record<string, string> = {
      activationType: 'activationTypePremiumAccountId',
      country: 'countryPremiumAccountId',
      language: 'languagePremiumAccountId',
      type: 'typePremiumAccountId',
      period: 'periodPremiumAccountId',
      pelan: 'pelanPremiumAccountId',
    };

    const idFieldName = idFieldMap[field];
    if (!idFieldName) {
      this.totalCurrencyAmount = 0;
      this.getTotalAmountLoading = false;
      this.cdr.detectChanges();
      return;
    }

    const idToMatch: string | null =
      idObject && typeof idObject[idFieldName] !== 'undefined'
        ? String(idObject[idFieldName])
        : null;

    if (!idToMatch) {
      this.totalCurrencyAmount = 0;
      this.getTotalAmountLoading = false;
      this.cdr.detectChanges();
      return;
    }

    const total = list
      .filter(
        (item) =>
          item &&
          item.priceEffectType === 20081 &&
          String(item[idFieldName]) === idToMatch
      )
      .reduce((sum, item) => sum + (Number(item.priceEffect) || 0), 0);

    this.totalCurrencyAmount = total;
    this.getTotalAmountLoading = false;
    this.cdr.detectChanges();
  }

  inquiry() {
    if (
      this.dataPermiumActivation ||
      this.dataPermiumCountry ||
      this.dataPermiumLanguage ||
      this.dataPermiumPeriod ||
      this.dataPermiumPlan ||
      this.dataPermiumType
    ) {
      this.isLoadingGetPrice = true;
      this.getPricePermium();
      this.cdr.detectChanges();
    }
  }

  submit(): void {
    if (!this.additionalFieldsValid()) {
      this._alert.error('لطفا از پر کردن تمام بخش‌های ستاره دار مطمئن شوید.');
      return;
    }
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency?.currencyId;
    this.model.activationTypePremiumAccountId =
      this.selectedPermiumActivation?.activationTypePremiumAccountId;
    this.model.countryPremiumAccountId =
      this.selectedPermiumCountry?.countryPremiumAccountId;
    this.model.languagePremiumAccountId =
      this.selectedPermiumLanguage?.languagePremiumAccountId;
    this.model.pelanPremiumAccountId =
      this.selectedPermiumPlan?.pelanPremiumAccountId;
    this.model.periodPremiumAccountId =
      this.selectedPermiumPeriod?.periodPremiumAccountId;
    this.model.typePremiumAccountId =
      this.selectedPermiumType?.typePremiumAccountId;
    this.model.orderType = this.orderType;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .post(Address.OrderPermiumAccountSave, this.model)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe({
          next: (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              `/dashboard/checkouts/premium-accounts/${response.data.orderId}`
            );
          },
          error: (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          },
        })
    );
  }

  additionalFieldsValid(): boolean {
    if (!this.additionalFiels.length) return true;

    let isValid = true;

    this.additionalFiels.forEach((field) => {
      if (
        !field.isDeleted &&
        (field.persianName?.trim() || field.englishName?.trim()) &&
        field.required === true &&
        (!field.value || String(field.value).trim() === '')
      ) {
        isValid = false;
      }
    });

    return isValid;
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  getPricePermium() {
    if (
      !this.selectedCurrency ||
      stringIsEmptyOrNull(this.selectedCurrency.currencyId)
    )
      return;
    this.model.currencyId = this.selectedCurrency?.currencyId;
    this.model.activationTypePremiumAccountId =
      this.selectedPermiumActivation?.activationTypePremiumAccountId;
    this.model.countryPremiumAccountId =
      this.selectedPermiumCountry?.countryPremiumAccountId;
    this.model.languagePremiumAccountId =
      this.selectedPermiumLanguage?.languagePremiumAccountId;
    this.model.pelanPremiumAccountId =
      this.selectedPermiumPlan?.pelanPremiumAccountId;
    this.model.periodPremiumAccountId =
      this.selectedPermiumPeriod?.periodPremiumAccountId;
    this.model.typePremiumAccountId =
      this.selectedPermiumType?.typePremiumAccountId;
    this.mark = this.selectedCurrency?.mark;
    this.model.orderType = this.orderType;
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderPermiumAccountGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }
  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  getStaticById() {
    this.subscriptions.unsubscribe();
    this.subscriptions = new Subscription();
    this.isLoadingGetStatic = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.orderType),
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response) {
              this.fixedEffectiveAmount = response.data.fixedEffectiveAmount;
              this.isShowFixedEffectiveAmount =
                response.data.isShowFixedEffectiveAmount;
              this.getPremiumAccountFull();
              this.cdr.detectChanges();
            }
          },
          (error) => {}
        )
    );
  }

  onDialogHide() {
    this.displayModal = false;
  }

  private clearState(): void {
    this.model = new PermiumAccountSaveModel();
    this.dataPrice = null;
    this.inquiryIsOk = false;
    this.dataCurrency = [];
    this.selectedCurrency = null;
    this.dataSteps = [];
    this.additionalFiels = [];
    this.dataQuestion = [];
    this.dataSetting = null;
    this.dataStatic = null;
    this.imageId = null;
    this.fixedEffectiveAmount = null;
    this.isShowFixedEffectiveAmount = false;
    this.model.count = 1;
    if (this.appChildComponent && this.appChildComponent.formAttr) {
      this.appChildComponent.formAttr.reset();
    }

    this.cdr.detectChanges();
  }
}
