import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-permium-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderPermiumComponent implements OnInit, OnDestroy {
  subscriptions = new Subscription();
  constructor(
    private _activatedRoute: ActivatedRoute,
    private _router: Router,
    private cdr: ChangeDetectorRef
  ) {}

  ngOnInit(): void {
    this._router.navigateByUrl(
      '/dashboard/services/premiumAccounts/' +
        this._activatedRoute.snapshot.params['orderType']
    );
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    this.cdr.detectChanges();
  }
}
