import {
  Component,
  OnDestroy,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';

import { scrollTop } from '@helpers/window.helper';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-permium',
  templateUrl: './permium.component.html',
  styleUrls: ['./permium.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PermiumComponent implements OnDestroy {
  subscriptions = new Subscription();

  constructor(private cdr: ChangeDetectorRef) {}

  onActivate(event) {
    scrollTop();
  }
  
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    this.cdr.detectChanges();
  }
}
