import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PermiumComponent } from './permium.component';
const routes: Routes = [
  {
    path: '',

    component: PermiumComponent,
    data: {
      breadcrumb: [
        {
          title: ' خرید و افتتاح حساب',
          url: '/dashboard/Cat/premiumAccounts',
   
        },
      ],
    },
    children: [
      {
        path: ':orderType',
        data: { title: ' خرید و افتتاح حساب' },
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderPermiumModule),
      },
      {
        path: ':orderType/:language',
        data: { title: 'خرید و افتتاح حساب' },
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderPermiumModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PermiumRoutingModule {}
