import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ServicesComponent } from './services.component';
const routes: Routes = [
  {
    path: '',
    component: ServicesComponent,
    data: {
      title: 'خدمات',
      breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
    },

    children: [
      {
        path: '',

        loadChildren: () =>
          import('./allServices/allServices.module').then(
            (m) => m.AllServicesModule
          ),
      },

      {
        path: 'university',

        loadChildren: () =>
          import('./university/university.module').then(
            (m) => m.UniversityModule
          ),
      },
      {
        path: 'perfectmoney',

        loadChildren: () =>
          import('./perfectmoney/perfectmoney.module').then(
            (m) => m.PerfectmoneyModule
          ),
      },
      {
        path: 'wise',

        loadChildren: () =>
          import('./wise/wise.module').then((m) => m.WiseModule),
      },
      {
        path: 'revolut',

        loadChildren: () =>
          import('./revolout/revolout.module').then((m) => m.RevoloutModule),
      },
      {
        path: 'zen',

        loadChildren: () =>
          import('./zen/zen.module').then((m) => m.ZenModule),
      },

      {
        path: 'paypal',

        loadChildren: () =>
          import('./paypal/paypal.module').then((m) => m.PaypalModule),
      },

      {
        path: 'payeer',

        loadChildren: () =>
          import('./payeer/payeer.module').then((m) => m.PayeerModule),
      },

      {
        path: 'swift',

        loadChildren: () =>
          import('./swift/swift.module').then((m) => m.SwiftModule),
      },

      {
        path: 'virtualserver',

        loadChildren: () =>
          import('./virtualServers/virtualServers.module').then(
            (m) => m.VirtualServersModule
          ),
      },

      {
        path: 'incomeCash',
        data: {
          title: 'نقد کردن درآمد ارزی',
        },
        loadChildren: () =>
          import('./service-cash/incomeCashOrder/incomeCashOrder.module').then(
            (m) => m.IncomeCashOrderModule
          ),
      },
      {
        path: 'incomeCash/:language',
        data: {
          title: 'نقد کردن درآمد ارزی',
        },
        loadChildren: () =>
          import('./service-cash/incomeCashOrder/incomeCashOrder.module').then(
            (m) => m.IncomeCashOrderModule
          ),
      },

      {
        path: 'accountRecharge',
        data: {
          title: ' شارژ حساب',
        },
        loadChildren: () =>
          import('./chargeAccount/chargeAccount.module').then(
            (m) => m.ChargeAccountModule
          ),
      },
      {
        path: 'accountRecharge/:language',
        data: {
          title: ' شارژ حساب',
        },
        loadChildren: () =>
          import('./chargeAccount/chargeAccount.module').then(
            (m) => m.ChargeAccountModule
          ),
      },


      {
        path: 'incomeCashExchange',
        data: {
          title: 'نقد کردن درآمد ارزی',
        },
        loadChildren: () =>
          import('./incomeCashExchange/incomeCashExchange.module').then(
            (m) => m.IncomeCashExchangeModule
          ),
      },
      {
        path: 'incomeCashExchange/:language',
        data: {
          title: 'نقد کردن درآمد ارزی',
        },
        loadChildren: () =>
          import('./incomeCashExchange/incomeCashExchange.module').then(
            (m) => m.IncomeCashExchangeModule
          ),
      },

      {
        path: 'giftcard',

        data: {
          title: 'گیفت کارت',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-giftCards/giftCard/giftCard.module').then(
            (m) => m.GiftCardModule
          ),
      },
      {
        path: 'giftcard/:language',

        data: {
          title: 'گیفت کارت',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-giftCards/giftCard/giftCard.module').then(
            (m) => m.GiftCardModule
          ),
      },

      {
        path: 'premiumAccounts',

        data: {
          title: 'خرید و افتتاح حساب',
        },
        loadChildren: () =>
          import('./service-permium/permium/permium.module').then(
            (m) => m.PermiumModule
          ),
      },

      {
        path: 'internationalPayment',
        data: {
          title: 'خرید از سایت های بین المللی',
        },
        loadChildren: () =>
          import(
            './paymentInternationalSites/paymentInternationalSites.module'
          ).then((m) => m.PaymentInternationalSitesModule),
      },

      {
        path: 'internationalPaymentb',
        data: {
          title: 'خرید از سایت های بین المللی',
        },
        loadChildren: () =>
          import(
            './paymentInternationalSitesPlanB/paymentInternationalSitesPlanB.module'
          ).then((m) => m.PaymentInternationalSitesPlanBModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ServicesRoutingModule { }
