import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectorRef,
} from '@angular/core';
import { Subscription, finalize } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import { IStatic } from '@interfaces/dbo/iStatic';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { CategoryModel } from '@models/dbo/categoryModel';
import { cloneDeep } from 'lodash-es';

@Component({
  selector: 'app-category',
  templateUrl: './category.component.html',
  styleUrls: ['./category.component.scss'],
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})

export class CategoryComponent
  implements OnInit, OnDestroy {
  subscriptions = new Subscription();
  isLoadingGetCategory: boolean = true;
  dataCategory: CategoryModel[] = [];
  key: string;
  staticData: IStatic;
  isLoadingFile:boolean = false
  isDesktop:boolean;
  header:CategoryModel = new CategoryModel
  button:CategoryModel = new CategoryModel

  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute
) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[17] != undefined &&
          event.url.split('/')[17] != null &&
          event.url.split('/')[17] != ''
        ) {
          this.handleChangeRoute(event.url.split('/')[12]);
        }
      }
    });
  }

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/Cat/' +
          this._activatedRoute.snapshot.params['language']
      );
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.handleChangeRoute(this._activatedRoute.snapshot.params['key']);
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {
  }

  handleChangeRoute(e: string) {
    this.key = e;
    this.getData();
  }

  loadFilesStaticImage(item: CategoryModel) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + item.imageId)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            item.fileUrl = response;
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  getData() {
    this.subscriptions.add(
      this._commonService
        .put(Address.GetAllMenu, {forSidebar: false, key:this.key},)
        .pipe(
          finalize(() => {
            this.isLoadingGetCategory = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data != null && response.data.length > 0) {
              let data;
              data = cloneDeep(response.data)
              for(let item of data){
                if(!item.parentId){
                  this.header = item
                }
                if(item.icon == 'button'){
                  this.button = item
                }
              }
              this.dataCategory = data.filter(
                (q) => q.parentId != null && q.icon != 'button'
              )

              for(let item of this.dataCategory){
                if(item.imageId){
                  this.loadFilesStaticImage(item)
                }
              }


            }
          },
          (error) => {}
        )
    );
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  goToLanding(url: string){
    window.open((url), '_blank');
  }
}