import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ServicesCategoryComponent } from './servicesCategory.component';
const routes: Routes = [
  {
    path: '',
    
    component: ServicesCategoryComponent,
    data:{breadcrumb:[{title:'صفحه دسته بندی',url:'/dashboard/Cat/',isBlock:true}]},
    children: [
      {
        path: ':key',
  
        loadChildren: () =>
          import('./category/category.module').then(
            (m) => m.CategoryModule
          ),
      },
      {
        path: ':key/:language',
  
        loadChildren: () =>
          import('./category/category.module').then(
            (m) => m.CategoryModule
          ),
      },
  
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ServicesCategoryRoutingModule {}
