import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { scrollTop } from '@helpers/window.helper';
import { StyleStore } from '@stores/style.store';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: 'swift',
  templateUrl: './swift.component.html',
  styleUrls: ['./swift.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class SwiftComponent implements OnInit, OnDestroy {
  subscriptions = new Subscription();
  url = window.location.href;
  orderType: string;

  constructor(
    private _styleStore: StyleStore,
    private cdr: ChangeDetectorRef,
    public _activatedroute: ActivatedRoute
  ) {}

  ngOnInit(): void {
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false,
    });
  }

  onActivate(event) {
    scrollTop();
  }

  getOrderType() {
    this.orderType = this.url.split('/')[5];
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
