import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { SwiftTransferPriceModel } from '@models/orders/SwiftTransferPriceModel';
import { SwiftTransferSaveModel } from 'src/app/core/params/order/SwiftTransferSaveModel';
import { CountryModel } from '@models/orders/CountryModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { FileUploadService } from '@services/fileUpload.service';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'form-swiftTransfer',
  templateUrl: './formSwift.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})

export class FormSwiftTransferComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  inquiryIsOk: boolean = false;
  dataCountry: CountryModel[] = [];
  dataCurrency: CurrencyModel[] = [];
  totalQuestionRecord: number = 0;
  selectedCountry: CountryModel;
  selectedCurrency: CurrencyModel;
  data: UserProfile;
  isValidLegalForm: boolean = true;
  timeout = null;
  dataPrice: SwiftTransferPriceModel = new SwiftTransferPriceModel();
  model: SwiftTransferSaveModel = new SwiftTransferSaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = true;
  isDesktop: boolean;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  limitNumber: number;
  orderType: number= 161;
  totalRecord: number = 0;
  imageId: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  isSideFix: boolean = false;
  displayModal: boolean = false;
  isVerifiedInfo: boolean = false;
  isLodingGetUrl: boolean;
  constructor(
    public _deviceDetectorService: DeviceDetectorService,
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _activatedroute: ActivatedRoute,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore,
    private _fileUploadService: FileUploadService
  ) {}
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedroute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/swift/fromIran/' +
          this._activatedroute.snapshot.params['language']
      );
    this.isLoadingGet = true;
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
  }

  hideAlarmOrder(){
    this.isVerifiedInfo = true
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {
    this.getFullOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,moduleType: 30001
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.getCountry();
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }
              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getCountry() {
    this.isLoadingGetCountry = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.CountryGetAll,
          { useInOrder: true, useInRegister: null },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCountry = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCountry = response.data.filter((item) => item.isActive);

            this._fileUploadService.fileUrlGeneratorPutCountry(
              this.dataCountry,
              'avatarId'
            );
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.countryId = this.selectedCountry.countryId;

    this.subscriptions.add(
      this._commonService
        .put(Address.SwiftTransferGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCountry &&
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.countryId = this.selectedCountry.countryId;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.SwiftTransferSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']);
            this._router.navigateByUrl(
              '/dashboard/checkouts/swift/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
