import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
} from "@angular/core";
import { ActivatedRoute, Router } from "@angular/router";
import { stringIsEmptyOrNull } from "@helpers/validator.helper";
import { Subscription } from 'rxjs';

@Component({
  selector: "app-swift-order",
  templateUrl: "./order.component.html",
  styleUrls: ["./order.component.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class OrderSwiftTransferComponent
  implements OnInit, OnDestroy, AfterViewInit {

  subscriptions = new Subscription();

  constructor(
    private _router: Router,
    private _activatedroute: ActivatedRoute,
  ){}

  ngOnInit(): void {
    if(!stringIsEmptyOrNull(this._activatedroute.snapshot.params['language']))
    this._router.navigateByUrl('/dashboard/services/swift/fromIran/'+this._activatedroute.snapshot.params['language']);
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

}
