import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ToIranComponent } from './toIran.component';
const routes: Routes = [
  {
    path: '',

    component: ToIranComponent,
    data: {
      breadcrumb: [
        {
          title: 'حواله به ایران',
          url: '/dashboard/services/swift/toIran',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'حواله به ایران' },

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderSendRemittanceToIranModule
          ),
      },
      {
        path: ':language',
        data: { title: 'حواله به ایران' },

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderSendRemittanceToIranModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ToIranRoutingModule {}
