import { NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { PaymentInternationalSitesSaveModel } from 'src/app/core/params/order/PaymentInternationalSitesSaveModel';
import { PaymentInternationalSitesPriceModel } from '@models/orders/PaymentInternationalSitesPriceModel';
import { IStatic } from '@interfaces/dbo/iStatic';
import { FileUploadService } from '@services/fileUpload.service';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'form-swift-university',
  templateUrl: './formSwiftUni.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormSwiftUniOrderComponent
  implements OnInit, OnDestroy, OnDestroy
{
  orderType: string = '983';
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetCountry: boolean = false;
  isLoadingGetStatic: boolean = true;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  data: UserProfile;
  totalQuestionRecord: number = 0;
  timeout = null;
  fixedEffectiveAmount: number;
  isShowFixedEffectiveAmount: boolean;
  staticData: IStatic;
  isDesktop: boolean;
  dataPrice: PaymentInternationalSitesPriceModel;
  model: PaymentInternationalSitesSaveModel =
    new PaymentInternationalSitesSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  url: string = null;
  file: File;
  progress: number = 0;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  displayModal: boolean = false;
  imageId: string;
  isPageLoading: boolean = false;
  dataUser: UserProfile;
  errMsg: any;
  isVerifiedInfo: boolean = false;

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    public _orderTypeStore: OrderTypeStore,
    public dialogService: DialogService,
    private _translateService: TranslateService
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          const newOrderType = event.url.split('/')[4];
          if (newOrderType && newOrderType !== this.orderType) {
            this.dataSetting.notificationListBeforeSave = null;
            this.imageId = null;
            this.handleChangeRoute();
          }
        }
      }
    });
  }

  ngOnInit(): void {
    this.clearState();
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.handleChangeRoute();
    this.cdr.detectChanges();
  }

  

  private clearState(): void {
    this.model = new PaymentInternationalSitesSaveModel();
    this.dataPrice = null;
    this.inquiryIsOk = false;
    this.dataCurrency = [];
    this.selectedCurrency = null;
    this.dataSteps = [];
    this.additionalFiels = [];
    this.dataQuestion = [];
    this.dataSetting = null;
    this.dataStatic = null;
    this.imageId = null;
    this.fixedEffectiveAmount = null;
    this.isShowFixedEffectiveAmount = false;
    if (this.appChildComponent && this.appChildComponent.formAttr) {
      this.appChildComponent.formAttr.reset();
    }
    this.cdr.detectChanges();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    if (this.timeout) {
      clearTimeout(this.timeout);
      this.timeout = null;
    }
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  handleChangeRoute() {
    this.clearState();
    this.isPageLoading = true;
    if (stringIsEmptyOrNull(this.orderType)) {
      this.isPageLoading = false;
      this.cdr.detectChanges();
    } else {
      this.getStaticById();
    }
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: Number(this.orderType),
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.isPageLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
              this.inquiry();
            }

            if (response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (this.dataCurrency && this.dataCurrency.length == 1) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.orderType = this.orderType;
    this.subscriptions.add(
      this._commonService
        .put(Address.PaymentInternationalSitesGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getStaticById() {
    this.isLoadingGetStatic = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.orderType),
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response) {
              this.staticData = response.data;
              this.getFullOrder();
            }
            if (this.staticData && this.staticData.fixedEffectiveAmount) {
              this.fixedEffectiveAmount = this.staticData.fixedEffectiveAmount;
              this.model.amount = this.fixedEffectiveAmount.toString();
              this.inquiry();
            }
            if (this.staticData && this.staticData.isShowFixedEffectiveAmount) {
              this.isShowFixedEffectiveAmount =
                this.staticData.isShowFixedEffectiveAmount;
            }
            if (this.staticData && this.staticData.imageId) {
              this.loadFilesStaticImage(this.staticData.imageId);
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  loadFilesStaticImage(id: string) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.staticData.fileUrl = response;

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  additionalFieldsValid(): boolean {
    if (!this.additionalFiels.length) return true;
    let isValid = true;
    this.additionalFiels.forEach((field) => {
      if (
        !field.isDeleted &&
        (field.persianName?.trim() || field.englishName?.trim()) &&
        field.required === true &&
        (!field.value || String(field.value).trim() === '')
      ) {
        isValid = false;
      }
    });
    return isValid;
  }

  submit() {
    if (!this.additionalFieldsValid()) {
      this._alert.error('لطفا از پر کردن تمام بخش‌های ستاره دار مطمئن شوید.');
      return;
    }
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.orderType = this.orderType;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.PaymentInternationalSitesSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._orderTypeStore.orderTypeBehavior.next(
              this.model.orderType
            );
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/internationalpayment/' +
                response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
