import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ApplicationFeeComponent } from './applicationFee.component';
const routes: Routes = [
  {
    path: '',
    component: ApplicationFeeComponent,
    data: {
      breadcrumb: [
        {
          title: 'اپلیکیشن فی',
          url: '/dashboard/services/university/applicationFee',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderApplicationFeeModule
          ),
      },
      {
        path: ':language',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderApplicationFeeModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ApplicationFeeRoutingModule {}
