import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  ViewChild,
  HostListener,
  ElementRef,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ApplicationFeePriceModel } from '@models/orders/ApplicationFeePriceModel';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { ApplicationFeeSaveModel } from 'src/app/core/params/order/ApplicationFeeSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { FileUploadService } from '@services/fileUpload.service';
import { isUrlValid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { DeviceDetectorService } from 'ngx-device-detector';
import { ApplicationFeeSaveGroupModel } from 'src/app/core/params/order/ApplicationFeeSaveGroupModel';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import {
  animate,
  state,
  style,
  transition,
  trigger,
} from '@angular/animations';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'form-applicationFee',
  templateUrl: './formApplicationFee.component.html',
  styleUrls: ['./formApplicationFee.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [
    trigger('questions', [
      state('hidden', style({ opacity: 0 })),
      state('visible', style({ opacity: 1 })),
      transition('hidden <=> visible', [animate('0.3s ease-in-out')]),
    ]),
  ],
})
export class FormApplicationFeeComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  model: ApplicationFeeSaveModel = new ApplicationFeeSaveModel();
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isShowOrder: boolean = true;
  data: UserProfile;
  timeout = null;
  dataPrice: ApplicationFeePriceModel;
  isValidLegalForm: boolean = true;
  isLoading: boolean = false;
  displayModal: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  url: string = null;
  file: File;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 162;
  isDesktop: boolean;
  isAccepted: boolean;
  sidebarVisible: boolean;
  totalQuestionRecord: number = 0;
  wholeAmount: number = 0;
  limit: boolean = false;
  elRef: ElementRef;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  formCount = [
    { value: 1 },
    { value: 2 },
    { value: 3 },
    { value: 4 },
    { value: 5 },
  ];
  selectedCount: { value: number };
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  imageId: string;
  dataUser: UserProfile;
  errMsg: any;
  isVerifiedInfo: boolean = false;

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/university/applicationFee/' +
          this._activatedRoute.snapshot.params['language']
      );
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {
    this.getFullOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  fileChange(event, item: ApplicationFeeSaveGroupModel = null) {
    if (item == null) {
      let fileList: FileList =
        event.target != undefined && event.target != null
          ? event.target.files
          : event;
      if (fileList.length > 0) {
        this.file = fileList[0];
        this.fileUpload();
      }
    } else {
      let fileList: FileList =
        event.target != undefined && event.target != null
          ? event.target.files
          : event;
      if (fileList.length > 0) {
        this.file = fileList[0];
        this.fileUpload(item);
      }
    }
  }

  fileUpload(item: ApplicationFeeSaveGroupModel = null) {
    this.cdr.detectChanges();
    if (item == null) {
      this.isLoadingFile = true;
      this.subscriptions.add(
        this._fileUploadService
          .fileUpload(this.file.name, this.file, Address.FileUploadBig)
          .subscribe((event: HttpEvent<any>) => {
            switch (event.type) {
              case HttpEventType.Sent:
                break;
              case HttpEventType.ResponseHeader:
                break;
              case HttpEventType.UploadProgress:
                var eventTotal = event.total ? event.total : 0;
                this.progress = Math.round((event.loaded / eventTotal) * 100);
                this.cdr.detectChanges();
                break;
              case HttpEventType.Response:
                if (event.body['data'] != null) {
                  this.model.fileId = event.body['data'];
                  this.loadFiles(event.body['data']);
                  this.isLoadingFile = false;
                  this.cdr.detectChanges();
                }
                setTimeout(() => {
                  this.progress = 0;
                  this.cdr.detectChanges();
                }, 1500);
            }
          })
      );
    } else {
      item.isLoadingFile = true;
      this.subscriptions.add(
        this._fileUploadService
          .fileUpload(this.file.name, this.file, Address.FileUploadBig)
          .subscribe((event: HttpEvent<any>) => {
            switch (event.type) {
              case HttpEventType.Sent:
                break;
              case HttpEventType.ResponseHeader:
                break;
              case HttpEventType.UploadProgress:
                var eventTotal = event.total ? event.total : 0;
                item.progress = Math.round((event.loaded / eventTotal) * 100);
                this.cdr.detectChanges();
                break;
              case HttpEventType.Response:
                if (event.body['data'] != null) {
                  item.fileId = event.body['data'];
                  this.loadFiles(item.fileId, item);
                  item.isLoadingGetFile = false;
                  this.cdr.detectChanges();
                }
                setTimeout(() => {
                  item.progress = 0;
                  this.cdr.detectChanges();
                }, 1500);
            }
          })
      );
    }
  }

  loadFiles(id: string, item: ApplicationFeeSaveGroupModel = null) {
    this.cdr.detectChanges();
    if (item == null) {
      this.isLoadingGetFile = true;
      this.isLoadingFile = true;
      this.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              this.isLoadingFile = false;
              this.isLoadingGetFile = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              this.url = response;

              this.cdr.detectChanges();
            },
            (err: any) => {},
            () => {}
          )
      );
    } else {
      item.isLoadingGetFile = true;
      item.isLoadingFile = true;
      this.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              item.isLoadingFile = false;
              item.isLoadingGetFile = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              item.url = response;

              this.cdr.detectChanges();
            },
            (err: any) => {},
            () => {}
          )
      );
    }
  }
  remove() {
    this.url = null;
    this.cdr.detectChanges();
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (
              this.dataCurrency &&
              this.dataCurrency.length > 0 &&
              !this.selectedCurrency
            ) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice(item: ApplicationFeeSaveGroupModel = null) {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;

            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry(item: ApplicationFeeSaveGroupModel = null) {
    clearTimeout(this.timeout);
    if (!item && this.model.amount) {
      if (
        this.selectedCurrency &&
        !isNaN(Number(this.model.amount)) &&
        Number(this.model.amount) > 0
      ) {
        this.isLoadingGetPrice = true;
        this.cdr.detectChanges();

        this.timeout = setTimeout(() => {
          this.getPrice();
        }, 900);
      }
    } else if (item) {
      this.model.applicationFeeType = '4';
      if (
        item.selectedCurrency &&
        !isNaN(Number(item.amount)) &&
        Number(item.amount) > 0
      ) {
        if (this.wholeAmount > 0) {
          item.isLoadingGetPrice = true;
        } else {
          this.isLoadingGetPrice = true;
        }
        this.cdr.detectChanges();
        item.amount = item.amount;
        this.timeout = setTimeout(() => {
          this.getPrice(item);
        }, 900);
      }
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (
      this.model.nameInEnglish === undefined ||
      stringIsEmptyOrNull(this.model.nameInEnglish)
    ) {
      this._alert.warning('از وارد کردن نام به انگلیسی مطمئن شوید.');
      return;
    }
    if (
      this.model.familyInEnglish === undefined ||
      stringIsEmptyOrNull(this.model.familyInEnglish)
    ) {
      this._alert.warning('از وارد کردن نام خانوادگی به انگلیسی مطمئن شوید.');
      return;
    }
    if (
      this.model.address === undefined ||
      stringIsEmptyOrNull(this.model.address)
    ) {
      this._alert.warning('از وارد کردن ادرس مطمئن شوید.');
      return;
    }
    if (
      this.model.userName === undefined ||
      stringIsEmptyOrNull(this.model.userName)
    ) {
      this._alert.warning('از وارد کردن نام کاربری مطمئن شوید.');
      return;
    }
    if (
      this.model.password === undefined ||
      stringIsEmptyOrNull(this.model.password)
    ) {
      this._alert.warning('از وارد کردن رمز عبور مطمئن شوید.');
      return;
    }

    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }

    if (!isUrlValid(this.model.address)) {
      this._alert.warning('لطفا آدرس صفحه ورود را بدرستی وارد نمایید');
      this.model.address = null;
      return;
    }

    this.model.applicationFeeType = '1';

    this.isLoading = true;
    this.subscriptions.add(
      this._commonService
        .post(Address.ApplicationFeeSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
