import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ApplicationFeePriceModel } from '@models/orders/ApplicationFeePriceModel';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { ApplicationFeeSaveModel } from 'src/app/core/params/order/ApplicationFeeSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { FileUploadService } from '@services/fileUpload.service';
import { isUrlValid } from '@helpers/validator.helper';
import { LegalOrderComponent } from '../../../components/legal-order/legal-order.component';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { LegalOrderModel } from 'src/app/core/params/order/LegalOrderModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-dormitory-fee-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderHostelFeeComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  legalOrder: LegalOrderModel = new LegalOrderModel();
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  data: UserProfile;
  currentRoute: string;
  timeout = null;
  totalQuestionRecord: number = 0;
  isValidLegalForm: boolean = true;
  dataPrice: ApplicationFeePriceModel;
  model: ApplicationFeeSaveModel = new ApplicationFeeSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  displayModal: boolean = false;
  url: string = null;
  file: File;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 177;
  isDesktop: boolean;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  imageId: string;
  isOnline: boolean = false;
  activeIndex: number = 0;
  orderOptions = [
    { value: 'swift', title: 'حواله سوئیفت' },
    { value: 'dormitory-fee', title: 'پرداخت آنلاین' },
  ];
  isVerifiedInfo: boolean = false;
  dataUser: UserProfile;
  errMsg: any;

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  routeTo() {
    if (this.currentRoute == 'swift') {
      this.isOnline = false;
      this._alert.info(
        'کاربر گرامی شما برای پرداخت هزینه خوابگاه بوسیله حواله سوئیفت، به صفحه این سفارش منتقل می شوید، لطفا اطلاعات موردنیاز را وارد نمایید.'
      );
      this._router.navigateByUrl('/dashboard/services/swift');
      return;
    }
    if (this.currentRoute == 'dormitoryFee') {
      this.isOnline = true;
    }

    this.getFullOrder();
  }

  ngOnInit(): void {
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
  }

  

  ngAfterViewInit() {
    this.getFullOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }
  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  fileUpload() {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBig)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.model.fileId = event.body['data'];
                this.loadFiles(event.body['data']);

                this.isLoadingFile = false;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.isLoadingGetFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;
            this.extensionStore = String(
              this.url.substring(this.url.lastIndexOf('.') + 1, this.url.length)
            ).toLowerCase();
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  remove() {
    this.url = null;
    this.cdr.detectChanges();
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }
              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.applicationFeeType = '3';
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    if (!isUrlValid(this.model.address)) {
      this._alert.warning('لطفا آدرس صفحه ورود را بدرستی وارد نمایید');
      return;
    }
    this.model.applicationFeeType = '3';

    this.model.currencyId = this.selectedCurrency.currencyId;

    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.ApplicationFeeSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/dormitory-fee/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
