import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { UniversityComponent } from './university.component';

const routes: Routes = [
  {
    path: '',
    component: UniversityComponent,
    data: {
      title: 'خدمات دانشگاهی',
      breadcrumb: [
        { title: 'خدمات دانشگاهی', url: '/dashboard/Cat/university' },
      ],
    },
    children: [
      {
        path: 'dormitoryFee',

        loadChildren: () =>
          import('./dormitoryFee/dormitoryFee.module').then(
            (m) => m.HostelFeeModule
          ),
      },
      {
        path: 'dormitoryFee/:language',

        loadChildren: () =>
          import('./dormitoryFee/dormitoryFee.module').then(
            (m) => m.HostelFeeModule
          ),
      },
      {
        path: 'tuition',

        loadChildren: () =>
          import('./universityTuition/universityTuition.module').then(
            (m) => m.UniversityTuitionModule
          ),
      },
      {
        path: 'tuition/:language',

        loadChildren: () =>
          import('./universityTuition/universityTuition.module').then(
            (m) => m.UniversityTuitionModule
          ),
      },

      {
        path: 'applicationFee',

        loadChildren: () =>
          import('./applicationFee/applicationFee.module').then(
            (m) => m.ApplicationFeeModule
          ),
      },
      {
        path: 'applicationFee/:language',

        loadChildren: () =>
          import('./applicationFee/applicationFee.module').then(
            (m) => m.ApplicationFeeModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class UniversityRoutingModule {}
