import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { UniversityTuitionComponent } from './universityTuition.component';
const routes: Routes = [
  {
    path: '',
    component: UniversityTuitionComponent,
    data: {
      breadcrumb: [
        {
          title: 'پرداخت شهریه دانشگاه',
          url: '/dashboard/services/university/tuition',
          isBlock: true,
        },
      ],
    },
    children: [
      { path: '', redirectTo: '', pathMatch: 'prefix' },
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderUniversityTuitionModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class UniversityTuitionRoutingModule {}
