import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { BuyTradeServersComponent } from './buyTradeServers.component';
const routes: Routes = [
  {
    path: '',
    component: BuyTradeServersComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید سرور مجازی ترید',
          url: '/dashboard/services/virtualserver/buyvirtualserver',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyTradeServersModule
          ),
      },
      {
        path: ':language',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyTradeServersModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class BuyTradeServersRoutingModule {}
