import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ElementRef,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { BuyTradeServersPriceModel } from '@models/orders/BuyTradeServersPriceModel';
import { BuyTradeServersSaveModel } from 'src/app/core/params/order/BuyTradeServersSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { DeviceDetectorService } from 'ngx-device-detector';
import { IServerPeriod } from '@interfaces/orders/iServerPeriod';
import { IServerRam } from '@interfaces/orders/iServerRam';
import { IServerRegion } from '@interfaces/orders/iServerRegion';
import { MenuItem } from 'primeng/api';
import { TranslateService } from '@ngx-translate/core';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';

@Component({
  selector: 'app-BuyTradeServers-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderBuyTradeServersComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  model: BuyTradeServersSaveModel = new BuyTradeServersSaveModel();
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;

  isLoadingGetVerify: boolean = false;
  isLoadingGetServerRam: boolean = false;
  isLoadingGetServerRegion: boolean = false;
  isLoadingGetServerPeriod: boolean = false;
  inquiryIsOk: boolean = false;
  dataRamServer: IServerRam[] = [];
  dataPeriodServer: IServerPeriod[] = [];
  dataRegionServer: IServerRegion[] = [];
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;

  data: UserProfile;
  timeout = null;
  dataPrice: BuyTradeServersPriceModel;
  isValidLegalForm: boolean = true;
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  displayModal: boolean = false;
  url: string = null;
  file: File;
  limitNumber: number;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 900;
  isDesktop: boolean;
  totalQuestionRecord: number = 0;
  type: number = 2;
  deactive: boolean = true;
  warnText: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  imageId: string;
  dataUser: UserProfile;
  errMsg: any;
  isVerifiedInfo: boolean = false;

  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _translateService: TranslateService,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  ngOnInit(): void {
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this._translateService
      .get('slectetRamValueFirst')
      .subscribe((response: string) => {
        this.warnText = response;
      });
    this.getFullOrder();
    this.cdr.detectChanges();
  }

  

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            this.getServerPeriod();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getServerRam() {
    this.isLoadingGetServerRam = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.ServerRamGetall,
          {
            serverType: this.orderType,
            currencyId: this.selectedCurrency.currencyId,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetServerRam = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataRamServer = response.data;
            if (this.dataRamServer && this.dataRamServer.length > 0) {
              this.model.serverRamId = this.dataRamServer[0].serverRamId;
            }
            this.getServerRegion();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getServerPeriod() {
    this.isLoadingGetServerPeriod = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.ServerPeriodGetall,
          {
            orderType: this.orderType,
            currencyId: this.selectedCurrency.currencyId,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetServerPeriod = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPeriodServer = response.data;
            if (this.dataPeriodServer && this.dataPeriodServer.length > 0) {
              this.model.serverPeriodId =
                this.dataPeriodServer[0].serverPeriodId;
            }
            this.getServerRam();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getServerRegion() {
    this.isLoadingGetServerRegion = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.ServerRegionRamGetAll,
          { serverRamId: this.model.serverRamId, serverType: this.orderType },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetServerRegion = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response && response.data) {
              this.dataRegionServer = response.data;
            }
            this.deactive = false;
            if (this.dataRegionServer && this.dataRegionServer.length > 0) {
              this.model.serverRamRegionId =
                this.dataRegionServer[0].serverRamRegionId;
              this.getAmountOfCountry();
            }
            this.inquiry();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.type = this.type;

    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.model.ServerType = '1';
    this.model.type = this.type;

    if (this.selectedCurrency)
      this.model.currencyId = this.selectedCurrency.currencyId;

    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.VirtualServersSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/virtualServers/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  getAmountOfCountry() {
    for (let item of this.dataRegionServer) {
      if (item.serverRamRegionId == this.model.serverRamRegionId) {
        this.model.amount = item.amount.toString();
        this.model.serverRegionId = item.serverRegionId;
      }
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
