import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { BuyVirtualServersComponent } from './buyVirtualServers.component';
const routes: Routes = [
  {
    path: '',
    component: BuyVirtualServersComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید سرور مجازی',
          url: '/dashboard/services/virtualserver/buyvirtualserver',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyVirtualServersModule
          ),
      },
      {
        path: ':language',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyVirtualServersModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class BuyVirtualServersRoutingModule {}
