import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { VirtualServersComponent } from './virtualServers.component';

const routes: Routes = [
  {
    path: '',
    component: VirtualServersComponent,
    data: {
      title: 'سرور مجازی',
      breadcrumb: [{ title: 'سرور مجازی', url: '/dashboard/Cat/server' }],
    },
    children: [
      {
        path: 'buyServer',

        loadChildren: () =>
          import('./buyVirtualServers/buyVirtualServers.module').then(
            (m) => m.BuyVirtualServersModule
          ),
      },
      {
        path: 'buyServer/:language',

        loadChildren: () =>
          import('./buyVirtualServers/buyVirtualServers.module').then(
            (m) => m.BuyVirtualServersModule
          ),
      },
      {
        path: 'renewalServer',

        loadChildren: () =>
          import('./renewalVirtualServers/renewalVirtualServers.module').then(
            (m) => m.RenewalVirtualServersModule
          ),
      },
      {
        path: 'renewalServer/:language',

        loadChildren: () =>
          import('./renewalVirtualServers/renewalVirtualServers.module').then(
            (m) => m.RenewalVirtualServersModule
          ),
      },
      {
        path: 'buyTradeServer',

        loadChildren: () =>
          import('./buyTradeServers/buyTradeServers.module').then(
            (m) => m.BuyTradeServersModule
          ),
      },
      {
        path: 'buyTradeServer/:language',

        loadChildren: () =>
          import('./buyTradeServers/buyTradeServers.module').then(
            (m) => m.BuyTradeServersModule
          ),
      },
      {
        path: 'renewalTradeServer',

        loadChildren: () =>
          import('./renewalTradeServers/renewalTradeServers.module').then(
            (m) => m.RenewalTradeServersModule
          ),
      },
      {
        path: 'renewalTradeServer/:language',

        loadChildren: () =>
          import('./renewalTradeServers/renewalTradeServers.module').then(
            (m) => m.RenewalTradeServersModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class VirtualServersRoutingModule {}
