import { cloneDeep } from 'lodash-es';
import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { SellingWisePriceModel } from '@models/orders/sellingWisePriceModel';
import { SellingWiseSaveModel } from 'src/app/core/params/order/SellingWiseSaveModel';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'form-SellingWise',
  templateUrl: './formSellingWise.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormSellingWiseComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetFullOrder: boolean = false;
  displayModal: boolean = false;
  isLoadingGetPrice: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  data: UserProfile;
  timeout = null;
  dataPrice: SellingWisePriceModel;
  model: SellingWiseSaveModel = new SellingWiseSaveModel();
  isLoading: boolean = false;
  isDesktop: boolean;
  totalQuestionRecord: number = 0;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  limitNumber: number;
  totalRecord: number = 0;
  orderType: number = 907;
  imageId: string;
  errMsg: any;
  isSideFix: boolean = false;
  isVerifiedInfo: boolean = false;

  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private viewportScroller: ViewportScroller,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  ngOnInit(): void {
    this.isLoadingGet = true;
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.cdr.detectChanges();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.data = res;
      }
    });
    this.cdr.detectChanges();
  }

  

  ngAfterViewInit() {
    this.getFullOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            orderType: this.orderType,
            isArchive: false,
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (this.dataCurrency && this.dataCurrency.length == 1) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingWiseGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = cloneDeep(response.data);
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.SellingWiseSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingwise/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
