import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { WiseComponent } from './wise.component';

const routes: Routes = [
  {
    path: '',
    component: WiseComponent,
    data: {
      title: 'وایز',
      breadcrumb: [{ title: 'وایز', url: '/dashboard/Cat/wise' }],
    },
    children: [
      {
        path: 'accountRecharge',

        loadChildren: () =>
          import('./wiseAccountCharge/wiseAccountCharge.module').then(
            (m) => m.WiseAccountChargeModule
          ),
      },
      {
        path: 'sell',

        loadChildren: () =>
          import('./sellingWise/sellingWise.module').then(
            (m) => m.SellingWiseModule
          ),
      },
      {
        path: 'sell/:language',

        loadChildren: () =>
          import('./sellingWise/sellingWise.module').then(
            (m) => m.SellingWiseModule
          ),
      },
      {
        path: 'accountRecharge/:language',

        loadChildren: () =>
          import('./wiseAccountCharge/wiseAccountCharge.module').then(
            (m) => m.WiseAccountChargeModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class WiseRoutingModule {}
