import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { WiseAccountChargeComponent } from './wiseAccountCharge.component';
const routes: Routes = [
  {
    path: '',
    component: WiseAccountChargeComponent,
    data: {
      breadcrumb: [
        {
          title: 'شارژ حساب وایز',
          url: '/dashboard/services/wise/accountRecharge',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderWiseAccountChargeModule
          ),
      },
      {
        path: ':language',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderWiseAccountChargeModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class WiseAccountChargeRoutingModule {}
