import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ZenComponent } from './zen.component';

const routes: Routes = [
  {
    path: '',
    component: ZenComponent,
    data: {
      title: 'Zen',
      breadcrumb: [{ title: 'Zen', url: '/dashboard/Cat/zen' }],
    },
    children: [
      {
        path: 'sell',

        loadChildren: () =>
          import('./zenSell/zenSell.module').then(
            (m) => m.ZenSellModule
          ),
      },
      {
        path: 'sell/:language',

        loadChildren: () =>
          import('./zenSell/zenSell.module').then(
            (m) => m.ZenSellModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ZenRoutingModule {}
