import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-SellingZen-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderSellingZenComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  constructor(
    private _activatedRoute: ActivatedRoute,
    private _router: Router
  ) {}

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/zen/sell/' +
          this._activatedRoute.snapshot.params['language']
      );
  }
  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
