import { ChangeDetectorRef, Component, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { Address } from '@enums/address.enum';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import { MenuItem } from 'primeng/api';
import { Subscription, finalize } from 'rxjs';

@Component({
  selector: 'step-wizard',
  templateUrl: 'step-wizard-checkout.component.html',
  styleUrls: ['step-wizard-checkout.component.scss'],
})
export class StepWizardComponent implements OnInit,OnChanges {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef
  ) {}

  @Input() stepsList: MenuItem[] = [];

  subscriptions = new Subscription();

  @Input() orderId;
  @Input() orderType;

  ngOnInit() {
    if(!stringIsEmptyOrNull(this.orderId))
    this.getStatus();
  }
  ngOnChanges(): void {
  }

  getStatus() {
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetStatus,
          { orderType: this.orderType, orderId: this.orderId },
          false
        )
        .pipe(
          finalize(() => {
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.stepsList = response.data;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
}
