import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import {
  DialogService,
  DynamicDialogConfig,
  DynamicDialogRef,
} from 'primeng/dynamicdialog';
import { SurveyComponent } from '../survey.component';
import { SurveyModel } from '@models/orders/surveyModel';

@Component({
  selector: 'modalSurvey',
  templateUrl: 'modalSurvey.component.html',
  styleUrls: ['modalSurvey.component.scss'],
})
export class ModalSurveyComponent implements OnInit {
  constructor(
    public ref: DynamicDialogRef,
    public config: DynamicDialogConfig,
    public dialogService: DialogService
  ) {}
  @Input() isShowOrderDetails: boolean;
  @Output() isShowOrderDetailsChange: EventEmitter<boolean> =
    new EventEmitter<boolean>();
  ngOnInit(): void {}
  @Input() isFromOrderDetail: boolean = false;
  modalContent(surveyData: SurveyModel = null) {
    let height = '90%';
    let width = '60%';
    let style = 'modal-order-details-survey';
    const ref = this.dialogService.open(SurveyComponent, {
      data: {
        surveyData: surveyData,
      },
      header: 'نظرسنجی',
      dismissableMask: true,
      styleClass: style,
      closable: true,
      height: height,
      width: width,
    });
    ref.onClose.subscribe((model: any) => {});
  }

  showOrderDetails() {
    this.isShowOrderDetailsChange.emit(true);
  }
}
